<?php

namespace UtillzCore\Inc\Src\Collection;

use \UtillzCore\Inc\Src\Listing\Listing;

class Collection {

    public $id;
    public $post;

    function __construct( $id = null ) {

        $this->id = $id ? $id : get_the_ID();
        $this->post = get_post( $this->id );

    }

    public function get_collection_listings( $num = 1 ) {

        $query = new \WP_Query([
            'post_type' => 'ulz_listing',
            'post_status' => 'publish',
            'posts_per_page' => $num,
            'fields' => 'ids',
            'meta_query' => [
                [
                    'key' => 'ulz_collection',
                    'value' => $this->id,
                    'compare' => 'IN',
                ],
            ],
        ]);

        return $query->posts;

    }

    public function get_collection_gallery( $num = 1, $size = 'ulz_listing' ) {

        $listings = $this->get_collection_listings( $num );
        $gallery = [];

        foreach( $listings as $listing_id ) {

            $listing = new Listing( $listing_id );

            if( $image = $listing->get_first_from_gallery( $size ) ) {
                $gallery[ $listing_id ] = $image;
            }

        }

        return $gallery;

    }

}
